# Entities Feed

**Module name:** Entities Feed
**Package:** Saibher
**Core compatibility:** Drupal 11.x
**Author:** Andres Felipe Rincon
**License:** GPL-2.0-or-later

---

## Overview

Entities Feed is a Drupal module that allows site builders and developers to **programmatically create and manage content types, taxonomies, and fields** using structured CSV files.

It works as a lightweight alternative to the default Drupal UI for entity creation — ideal for provisioning environments, CI/CD pipelines, or mass entity setup in new installations.

The module reads CSV file and automatically generates the necessary entities (content types, vocabularies, fields, and terms) without manual configuration.

---

## Features

* Create content types and their fields from CSV files.
* Create taxonomies and terms programmatically.
* Import entities via admin UI form.
* Safe and idempotent — checks if entities already exist before creating them.
* Easy to integrate in deployment and automation workflows.

---

## Requirements

* Drupal 11.x
* PHP 8.2 or higher

---

## Installation

1. Install module using composer as common
2. Enable the module:

   ```bash
   drush en entities_feed
   ```

---

## Usage

1. Go to **Configuration → Development → Entities Feed Importer**.
2. Choose into entities creation or fields creation
3. Upload your CSV file and click *Import*.

## Uninstallation

To uninstall the module:

```bash
drush pm:uninstall entities_feed
```

## Development & Contribution

Contributions are welcome! Please follow Drupal.org contribution guidelines.

To report issues or propose new features, open an issue in the project repository or submit a patch via Drupal.org.

### Local development

To test the module locally:

```bash
drush en entities_feed -y
drush cr
```

---

## Maintainers

* **Andres Felipe Rincon** — [Andres Felipe Rincon Gracia (saibher)](https://www.drupal.org/u/saibher)

---

## License

This project is licensed under the GNU General Public License v2.0 or later.
See the [LICENSE.txt](LICENSE.txt) file for deta
