<?php

namespace Drupal\entity_404\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityDisplayRepositoryInterface;

/**
 * Deny access if an entity doesn't have a full view.
 */
class HasFullView extends Entity404Base {

  /**
   * The entity display repository.
   *
   * @var \Drupal\Core\Entity\EntityDisplayRepositoryInterface
   */
  protected EntityDisplayRepositoryInterface $entityDisplayRepository;

  /**
   * Class constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   * @param \Drupal\Core\Entity\EntityDisplayRepositoryInterface $entity_display_repository
   *   The entity display repository.
   */
  public function __construct(ConfigFactoryInterface $config_factory, EntityDisplayRepositoryInterface $entity_display_repository) {
    parent::__construct($config_factory, 'no_full_view');

    $this->entityDisplayRepository = $entity_display_repository;
  }

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(ContentEntityInterface $entity): AccessResult {
    $view_modes = $this->entityDisplayRepository->getViewModeOptionsByBundle(
      $entity->getEntityTypeId(),
      $entity->bundle()
    );

    if (isset($view_modes['full'])) {
      $result = AccessResult::allowed();
    }
    else {
      $result = AccessResult::forbidden('No full view');
    }

    return $result->addCacheTags([
      "config:core.entity_view_display.{$entity->getEntityTypeId()}.{$entity->bundle()}.full",
    ]);
  }

}
