<?php

namespace Drupal\entity_404\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form to edit the settings.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['entity_404.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'entity_404_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('entity_404.settings');

    $form['404_if'] = [
      '#type' => 'details',
      '#title' => $this->t('Render the 404 (not found) page when accessing an entity without a...'),
      '#open' => TRUE,
    ];

    $form['404_if']['no_full_view'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Full view mode'),
      '#default_value' => (int) $config->get('no_full_view'),
      '#config_target' => 'entity_404.settings:no_full_view',
    ];

    $form['404_if']['no_translation'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Translation'),
      '#default_value' => (int) $config->get('no_translation'),
      '#config_target' => 'entity_404.settings:no_translation',
    ];

    return parent::buildForm($form, $form_state);
  }

}
