<?php

namespace Drupal\entity_404\Path;

use Drupal\Core\Path\PathValidatorInterface;
use Drupal\Core\Url;
use Drupal\entity_404\ToggleInterface;

/**
 * Decorates the path validator from core.
 */
class PathValidator implements PathValidatorInterface {

  /**
   * Class constructor.
   *
   * @param \Drupal\Core\Path\PathValidatorInterface $inner
   *   The decorated path validator.
   * @param \Drupal\entity_404\ToggleInterface $hasTranslationAccess
   *   The has translation access check.
   */
  public function __construct(
    protected PathValidatorInterface $inner,
    protected ToggleInterface $hasTranslationAccess,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function getUrlIfValid($path): Url|bool {
    $this->hasTranslationAccess->toggleOff();

    try {
      return $this->inner->getUrlIfValid($path);
    }
    finally {
      $this->hasTranslationAccess->toggleOn();
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getUrlIfValidWithoutAccessCheck($path): Url|bool {
    return $this->inner->getUrlIfValidWithoutAccessCheck($path);
  }

  /**
   * {@inheritdoc}
   */
  public function isValid($path): bool {
    $this->hasTranslationAccess->toggleOff();

    try {
      return $this->inner->isValid($path);
    }
    finally {
      $this->hasTranslationAccess->toggleOn();
    }
  }

}
