<?php

namespace Drupal\entity_404;

/**
 * Provides an interface to on the fly toggle a service on/off.
 */
interface ToggleInterface {

  /**
   * Check if the service is toggled on.
   *
   * @return bool
   *   TRUE if the service is toggled on.
   */
  public function isToggledOn(): bool;

  /**
   * Toggle the service on.
   */
  public function toggleOn(): void;

  /**
   * Toggle the service on.
   */
  public function toggleOff(): void;

}
