<?php

declare(strict_types=1);

namespace Drupal\entity_access_password_user_data_backend\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\entity_access_password_user_data_backend\Service\UserDataBackendInterface;
use Drupal\user\UserDataInterface;

/**
 * Purge user data on entity deletion.
 */
class EntityDelete {

  public function __construct(
    protected UserDataInterface $userData,
    protected UserDataBackendInterface $userDataBackend,
  ) {}

  /**
   * Implements hook_entity_delete().
   *
   * Purge user data on entity deletion.
   */
  #[Hook('entity_delete')]
  public function entityDelete(EntityInterface $entity): void {
    if (!$entity instanceof FieldableEntityInterface) {
      return;
    }

    $this->userData->delete(UserDataBackendInterface::MODULE_NAME, NULL, $this->userDataBackend->getEntityName($entity));
  }

}
