<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\file\FileInterface;

/**
 * Allows to alter the list of entities checked to access a private file.
 */
class FileUsageEntityListEvent extends Event {

  /**
   * Constructor.
   *
   * @phpstan-param \Drupal\Core\Entity\EntityInterface[] $entities
   */
  public function __construct(
    protected FileInterface $file,
    protected array $entities,
  ) {}

  /**
   * Returns the file entity.
   *
   * @return \Drupal\file\FileInterface
   *   The file being manipulated.
   */
  public function getFile(): FileInterface {
    return $this->file;
  }

  /**
   * Returns the list of entities to check.
   *
   * @return \Drupal\Core\Entity\EntityInterface[]
   *   The list of entities the access will be checked.
   */
  public function getEntities(): array {
    return $this->entities;
  }

  /**
   * Set the new list of entities to check for.
   *
   * @param \Drupal\Core\Entity\EntityInterface[] $entities
   *   The list of entities to check.
   */
  public function setEntities(array $entities): void {
    $this->entities = $entities;
  }

}
