<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Service;

use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Provides a password access storage manager.
 */
class AccessStorageManager implements AccessStorageInterface {

  public function __construct(
    protected iterable $storages,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function storeEntityAccess(FieldableEntityInterface $entity): void {
    foreach ($this->storages as $storage) {
      /** @var \Drupal\entity_access_password\Service\AccessStorageInterface $storage */
      $storage->storeEntityAccess($entity);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function storeEntityBundleAccess(FieldableEntityInterface $entity): void {
    foreach ($this->storages as $storage) {
      /** @var \Drupal\entity_access_password\Service\AccessStorageInterface $storage */
      $storage->storeEntityBundleAccess($entity);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function storeGlobalAccess(): void {
    foreach ($this->storages as $storage) {
      /** @var \Drupal\entity_access_password\Service\AccessStorageInterface $storage */
      $storage->storeGlobalAccess();
    }
  }

}
