<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Service;

use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;

/**
 * Default entity type password bundle info.
 */
class EntityTypePasswordBundleInfo implements EntityTypePasswordBundleInfoInterface {

  /**
   * The password infos.
   *
   * @var array|null
   */
  protected ?array $passwordInfos;

  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected EntityTypeBundleInfoInterface $entityTypeBundleInfo,
    protected EntityFieldManagerInterface $entityFieldManager,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getAllPasswordBundleInfo(): array {
    if (!isset($this->passwordInfos)) {
      $password_infos = [];

      $entity_types = $this->entityTypeManager->getDefinitions();
      foreach ($entity_types as $entity_type_id => $entity_type) {
        if (!$entity_type instanceof ContentEntityTypeInterface) {
          continue;
        }

        $bundles_infos = $this->entityTypeBundleInfo->getBundleInfo($entity_type_id);
        foreach ($bundles_infos as $bundle_id => $bundle_infos) {
          $bundle_fields = $this->entityFieldManager->getFieldDefinitions($entity_type_id, $bundle_id);
          foreach ($bundle_fields as $bundle_field) {
            if ($bundle_field->getType() == 'entity_access_password_password') {
              $password_infos[$entity_type_id]['entity_type'] = $entity_type;
              $password_infos[$entity_type_id]['bundles'][$bundle_id] = $bundle_infos;
              break;
            }
          }
        }
      }

      $this->passwordInfos = $password_infos;
    }

    return $this->passwordInfos;
  }

}
