<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Service;

use Drupal\Component\Render\FormattableMarkup;
use Drupal\Component\Utility\Xss;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Security\TrustedCallbackInterface;
use Drupal\entity_access_password\Form\PasswordFormInterface;

/**
 * Provides a lazy builder for password form.
 */
class PasswordFormBuilder implements PasswordFormBuilderInterface, TrustedCallbackInterface {

  public function __construct(
    protected FormBuilderInterface $formBuilder,
    protected EntityTypeManagerInterface $entityTypeManager,
    protected PasswordFormInterface $passwordForm,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function build(string $helpText, string $hint, int $entityId, string $entityTypeId, string $fieldName): array {
    /** @var \Drupal\Core\Entity\FieldableEntityInterface $entity */
    $entity = $this->entityTypeManager->getStorage($entityTypeId)
      ->load($entityId);

    $itemsData = $entity->get($fieldName)->get(0);
    $this->passwordForm->setFormIdSuffix($entityTypeId . '_' . $entityId);

    return [
      '#theme' => 'entity_access_password_form',
      '#help_text' => new FormattableMarkup(Xss::filterAdmin($helpText), []),
      '#hint' => Xss::filter($hint),
      // @phpstan-ignore-next-line
      '#form' => $this->formBuilder->getForm($this->passwordForm, $itemsData),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks(): array {
    return ['build'];
  }

}
