<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Service;

use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Routing\StackedRouteMatchInterface;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

/**
 * The default route parser.
 */
class RouteParser implements RouteParserInterface {

  /**
   * The entity if present. NULL otherwise.
   *
   * @var \Drupal\Core\Entity\FieldableEntityInterface|null
   */
  protected ?FieldableEntityInterface $foundEntity;

  public function __construct(
    #[Autowire(service: RouteMatchInterface::class)]
    protected StackedRouteMatchInterface $routeMatch,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getEntityFromCurrentRoute() {
    if (isset($this->foundEntity)) {
      return $this->foundEntity;
    }

    $currentRouteMatch = $this->routeMatch->getCurrentRouteMatch();
    $route = $currentRouteMatch->getRouteObject();
    if ($route == NULL) {
      $this->foundEntity = NULL;
      return $this->foundEntity;
    }

    $options = $route->getOptions();

    $entity_parameter_key = '';
    if (isset($options['parameters']) && \is_array($options['parameters'])) {
      foreach ($options['parameters'] as $parameter_key => $parameter) {
        if (isset($parameter['type'])
          && \is_string($parameter['type'])
          && \substr($parameter['type'], 0, \strlen(static::SEARCHED_TYPE)) === static::SEARCHED_TYPE
        ) {
          $entity_parameter_key = $parameter_key;
          // Stop on the first one found.
          break;
        }
      }
    }

    if (empty($entity_parameter_key)) {
      $this->foundEntity = NULL;
      return $this->foundEntity;
    }

    $parameters = $currentRouteMatch->getParameters();
    $entity = $parameters->get($entity_parameter_key);

    if (!$entity instanceof FieldableEntityInterface) {
      $this->foundEntity = NULL;
      return $this->foundEntity;
    }

    $this->foundEntity = $entity;
    return $this->foundEntity;
  }

}
