<?php

declare(strict_types=1);

namespace Drupal\entity_access_password_migration_examples_lesson\Plugin\migrate\source;

use Drupal\migrate_drupal\Plugin\migrate\source\DrupalSqlBase;

/**
 * Source plugin for protected_node migration.
 *
 * @MigrateSource(
 *     id = "protected_node"
 * )
 *
 * @phpstan-ignore-next-line
 */
class ProtectedNode extends DrupalSqlBase implements \Stringable {

  /**
   * {@inheritdoc}
   */
  public function query() {
    // Query d7 db table node.
    // @phpstan-ignore-next-line
    $query = $this->select('node', 'node');
    // @phpstan-ignore-next-line
    $query->fields('node');

    // Replace lesson by your custom protected node node type.
    // @phpstan-ignore-next-line
    $query->condition('node.type', 'lesson', '=');

    // @phpstan-ignore-next-line
    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function fields() {
    // Only used for Migration UI.
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getIds() {
    return [
      'nid' => [
        'type' => 'integer',
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function __toString() {
    return $this->query()->__toString();
  }

}
