<?php

declare(strict_types=1);

namespace Drupal\entity_access_password_user_data_backend\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\entity_access_password\Service\EntityTypePasswordBundleInfoInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides common code for deriver.
 */
abstract class UserDataBackendDeriverBase extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  public function __construct(
    protected EntityTypePasswordBundleInfoInterface $entityTypePasswordBundleInfo,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id): static {
    return new static(
      $container->get(EntityTypePasswordBundleInfoInterface::class)
    );
  }

}
