<?php

declare(strict_types=1);

namespace Drupal\entity_access_password\Service;

use Drupal\entity_access_password\Plugin\Field\FieldType\EntityAccessPasswordItem;

/**
 * Provides a password validator manager.
 */
class PasswordValidatorManager implements PasswordValidatorInterface {

  public function __construct(
    protected iterable $validators,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function validatePassword(string $password, EntityAccessPasswordItem $fieldItem): bool {
    foreach ($this->validators as $validator) {
      /** @var \Drupal\entity_access_password\Service\PasswordValidatorInterface $validator */
      if ($validator->validatePassword($password, $fieldItem)) {
        return TRUE;
      }
    }

    return FALSE;
  }

}
