<?php

declare(strict_types=1);

namespace Drupal\entity_attributes_eck\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\entity_attributes\EntityAttributesProcessor;

/**
 * Hook implementations for entity attributes ECK preprocess.
 */
class PreprocessHooks {

  /**
   * The entity attributes processor.
   */
  protected EntityAttributesProcessor $processor;

  /**
   * Constructs an EntityAttributesHooks object.
   *
   * @param \Drupal\entity_attributes\EntityAttributesProcessor $processor
   *   The entity attributes processor.
   */
  public function __construct(EntityAttributesProcessor $processor) {
    $this->processor = $processor;
  }

  /**
   * Implements hook_preprocess_eck_entity().
   *
   * @usedby EckEntityAttributes
   */
  #[Hook('preprocess_eck_entity')]
  public function preprocessEckEntity(array &$variables): void {
    /** @var \Drupal\eck\Entity\EckEntity $eck_entity */
    $eck_entity = $variables['eck_entity'];
    $entity_type = $eck_entity->getEntityTypeId();
    $this->processor->processContentEntityAttributes($eck_entity, $variables, $entity_type);
  }

}
