<?php

namespace Drupal\entity_attributes_eck\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ContentEntityAttributesBase;

/**
 * Plugin for ECK entity attributes.
 */
#[EntityAttributes(
  id: 'eck_entity',
  label: new TranslatableMarkup('ECK Entity'),
  description: new TranslatableMarkup('Manages attributes for ECK entities.'),
  config_tab: 'eck_entity',
  config_tab_label: new TranslatableMarkup('ECK Entity'),
  config_section: 'bundles',
)]
class EckEntityAttributes extends ContentEntityAttributesBase {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypes(): array {
    // Return ECK entity type IDs dynamically.
    $eck_entity_types = $this->entityTypeManager->getStorage('eck_entity_type')->loadMultiple();
    $entity_type_ids = [];

    foreach ($eck_entity_types as $eck_entity_type) {
      $entity_type_ids[] = $eck_entity_type->id();
    }

    return $entity_type_ids;
  }

}
