<?php

declare(strict_types=1);

namespace Drupal\entity_attributes_paragraphs\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\entity_attributes\EntityAttributesProcessor;

/**
 * Hook implementations for entity attributes paragraphs preprocess.
 */
class PreprocessHooks {

  /**
   * The entity attributes processor.
   */
  protected EntityAttributesProcessor $processor;

  /**
   * Constructs an EntityAttributesHooks object.
   *
   * @param \Drupal\entity_attributes\EntityAttributesProcessor $processor
   *   The entity attributes processor.
   */
  public function __construct(EntityAttributesProcessor $processor) {
    $this->processor = $processor;
  }

  /**
   * Implements hook_preprocess_paragraph().
   *
   * @usedby ParagraphAttributes
   */
  #[Hook('preprocess_paragraph')]
  public function preprocessParagraph(array &$variables): void {
    /** @var \Drupal\paragraphs\Entity\Paragraph $paragraph */
    $paragraph = $variables['paragraph'];
    $this->processor->processContentEntityAttributes($paragraph, $variables, 'paragraph');
  }

}
