<?php

namespace Drupal\entity_attributes_paragraphs\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ContentEntityAttributesBase;

/**
 * Plugin for Paragraph entity attributes.
 */
#[EntityAttributes(
  id: 'paragraph',
  label: new TranslatableMarkup('Paragraph'),
  entity_types: ['paragraph'],
  description: new TranslatableMarkup('Manages attributes for paragraph entities.'),
  config_tab: 'paragraph',
  config_tab_label: new TranslatableMarkup('Paragraph'),
  config_section: 'bundles',
)]
class ParagraphAttributes extends ContentEntityAttributesBase {

  /* This plugin doesn't override any base class methods. */

}
