<?php

namespace Drupal\entity_attributes\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Defines an Entity Attributes plugin annotation.
 *
 * @see \Drupal\entity_attributes\EntityAttributesManager
 * @see plugin_api
 *
 * @Annotation
 */
class EntityAttributes extends Plugin {

  /**
   * The plugin ID.
   */
  public string $id;

  /**
   * The label of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $label;

  /**
   * The entity type IDs this plugin supports.
   */
  public array $entity_types;

  /**
   * The description of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $description;

  /**
   * The configuration tab name for grouping plugins.
   */
  public string $config_tab = 'other';

  /**
   * The translatable label for the configuration tab.
   *
   * @ingroup plugin_translatable
   */
  public Translation $config_tab_label;

  /**
   * The configuration section within the tab (main, bundles, plugins).
   */
  public string $config_section = 'main';

}
