<?php

namespace Drupal\entity_attributes\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an Entity Attributes plugin attribute.
 *
 * @see \Drupal\entity_attributes\EntityAttributesManager
 * @see plugin_api
 */
#[\Attribute]
class EntityAttributes extends Plugin {

  /**
   * Constructs an EntityAttributes attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The label of the plugin.
   * @param array|null $entity_types
   *   The entity type IDs this plugin supports. Can be empty for dynamically generated types.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the plugin.
   * @param string $config_tab
   *   The configuration tab name for grouping plugins.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $config_tab_label
   *   The translatable label for the configuration tab.
   * @param string $config_section
   *   The configuration section within the tab (main, bundles, plugins).
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?array $entity_types = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly string $config_tab = 'other',
    public readonly ?TranslatableMarkup $config_tab_label = NULL,
    public readonly string $config_section = 'main',
    ?string $deriver = NULL,
  ) {
    parent::__construct($id, $deriver);
  }

}
