<?php

namespace Drupal\entity_attributes\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ConfigEntityAttributesBase;

/**
 * Plugin for Block entity attributes.
 */
#[EntityAttributes(
  id: 'block',
  label: new TranslatableMarkup('Block'),
  entity_types: ['block'],
  description: new TranslatableMarkup('Manages attributes for block configuration entities.'),
  config_tab: 'block',
  config_tab_label: new TranslatableMarkup('Block'),
  config_section: 'main',
)]
class BlockAttributes extends ConfigEntityAttributesBase {

  /**
   * {@inheritdoc}
   */
  public function getBundles(string $entity_type): array {
    return ['block' => $this->t('Block')];
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedAttributeSets(): array {
    return [
      'attributes',
      'title_attributes',
      'content_attributes',
    ];
  }

}
