<?php

declare(strict_types=1);

namespace Drupal\entity_attributes\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ConfigEntityAttributesBase;

/**
 * Plugin for Menu entity attributes.
 */
#[EntityAttributes(
  id: 'menu',
  label: new TranslatableMarkup('Menu'),
  entity_types: ['menu'],
  description: new TranslatableMarkup('Manages attributes for menu configuration entities.'),
  config_tab: 'menu',
  config_tab_label: new TranslatableMarkup('Menu'),
  config_section: 'main',
)]
class MenuAttributes extends ConfigEntityAttributesBase {

  /**
   * {@inheritdoc}
   */
  public function getBundles(string $entity_type): array {
    return ['menu' => $this->t('Menu')];
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedAttributeSets(): array {
    return [
      'attributes',
      'title_attributes',
      'content_attributes',
    ];
  }

}
