<?php

declare(strict_types=1);

namespace Drupal\entity_attributes\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ContentEntityAttributesBase;

/**
 * Plugin for Menu Link Content entity attributes.
 */
#[EntityAttributes(
  id: 'menu_link_content',
  label: new TranslatableMarkup('Menu Link Content'),
  entity_types: ['menu_link_content'],
  description: new TranslatableMarkup('Manages attributes for menu link content entities.'),
  config_tab: 'menu',
  config_tab_label: new TranslatableMarkup('Menu'),
  config_section: 'plugins',
)]
class MenuLinkContentAttributes extends ContentEntityAttributesBase {

  /**
   * {@inheritdoc}
   */
  public function getBundles(string $entity_type): array {
    return ['menu_link_content' => $this->t('Content Menu Link')];
  }

  /**
   * {@inheritdoc}
   */
  public function getSupportedAttributeSets(): array {
    return [
      'attributes',
      'link_attributes',
    ];
  }

}
