<?php

namespace Drupal\entity_attributes\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ContentEntityAttributesBase;

/**
 * Plugin for Node entity attributes.
 */
#[EntityAttributes(
  id: 'node',
  label: new TranslatableMarkup('Node'),
  entity_types: ['node'],
  description: new TranslatableMarkup('Manages attributes for node entities.'),
  config_tab: 'node',
  config_tab_label: new TranslatableMarkup('Node'),
  config_section: 'bundles',
)]
class NodeAttributes extends ContentEntityAttributesBase {

  /**
   * {@inheritdoc}
   */
  public function getSupportedAttributeSets(): array {
    return [
      'attributes',
      'title_attributes',
      'content_attributes',
      'author_attributes',
    ];
  }

}
