<?php

namespace Drupal\entity_attributes\Plugin\EntityAttributes;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\entity_attributes\Attribute\EntityAttributes;
use Drupal\entity_attributes\ContentEntityAttributesBase;

/**
 * Plugin for Taxonomy Term entity attributes.
 */
#[EntityAttributes(
  id: 'taxonomy_term',
  label: new TranslatableMarkup('Taxonomy Term'),
  entity_types: ['taxonomy_term'],
  description: new TranslatableMarkup('Manages attributes for taxonomy term entities.'),
  config_tab: 'taxonomy',
  config_tab_label: new TranslatableMarkup('Taxonomy'),
  config_section: 'bundles',
)]
class TaxonomyTermAttributes extends ContentEntityAttributesBase {

  /* This plugin doesn't override any base class methods. */

}
