<?php

namespace Drupal\entity_attributes\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'entity_attributes_hidden' formatter.
 */
#[FieldFormatter(
  id: 'entity_attributes_hidden',
  label: new TranslatableMarkup('Attributes (hidden)'),
  field_types: [
    'string_long',
  ],
)]
class AttributesFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    // This formatter deliberately returns no visible output.
    // Attributes are processed in template preprocessing hooks,
    // not displayed as field content.
    return [];
  }

}
