<?php

declare(strict_types=1);

namespace Drupal\entity_attributes\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that the value is valid YAML.
 */
#[Constraint(
  id: 'ValidYaml',
  label: new TranslatableMarkup('Valid YAML', [], ['context' => 'Validation'])
)]
class ValidYamlConstraint extends SymfonyConstraint {

  /**
   * The error message for invalid YAML.
   */
  public string $invalidMessage = 'Invalid YAML format: @error';

  /**
   * The error message for non-array YAML.
   */
  public string $notArrayMessage = 'Attributes must be in valid YAML format.';

}
