<?php

declare(strict_types=1);

namespace Drupal\entity_attributes\Plugin\Validation\Constraint;

use Drupal\Component\Serialization\Yaml;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that a given value is valid YAML.
 */
class ValidYamlConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $value, Constraint $constraint): void {
    \assert($constraint instanceof ValidYamlConstraint);

    // Allow empty values.
    if (empty($value)) {
      return;
    }

    try {
      $parsed = Yaml::decode($value);
      if (!\is_array($parsed) && !\is_null($parsed)) {
        $this->context->addViolation($constraint->notArrayMessage);
      }
    }
    catch (\Exception $e) {
      $this->context->addViolation($constraint->invalidMessage, [
        '@error' => $e->getMessage(),
      ]);
    }
  }

}
