# Entity Browser Acquia DAM

A Drupal module that provides Entity Browser widgets for integrating with Acquia DAM (Digital Asset Management).

## Overview

This module extends Drupal's Entity Browser functionality to seamlessly integrate with Acquia DAM, allowing users to upload assets directly to DAM and browse/select existing DAM assets within Drupal's content creation workflow.

## Features

### Upload Widget (`AcquiaDamUpload`)
- **Direct DAM Upload**: Upload files directly to Acquia DAM from Drupal
- **Automatic Media Type Detection**: Leverages Acquia DAM's built-in `MediaTypeResolver` to automatically determine the appropriate media type based on file properties
- **Seamless Integration**: Creates Drupal media entities that reference DAM assets
- **Flexible File Support**: Accepts all common file types (images, videos, audio, documents, archives)

### Browser Widget (`AcquiaDam`)
- **DAM Asset Browsing**: Browse and search existing assets in Acquia DAM
- **Advanced Filtering**: Filter by category, format type, and search terms
- **Format Restriction**: Optionally restrict browsing to specific media types
- **Responsive Design**: Modern, accessible interface with mobile support

## Why This Approach?

### Automatic Media Type Detection
Instead of implementing client-side file extension restrictions, this module leverages Acquia DAM's sophisticated `MediaTypeResolver` service. This approach is superior because:

1. **Accuracy**: DAM's resolver analyzes actual file content and metadata, not just extensions
2. **Consistency**: Ensures the same classification logic used across the entire DAM platform
3. **Maintainability**: No need to maintain separate extension-to-type mappings
4. **Flexibility**: Supports complex file types and edge cases automatically

### Simplified Configuration
The module removes unnecessary complexity by:
- Eliminating redundant media type configuration in upload forms
- Relying on DAM's automatic classification
- Focusing configuration on user experience rather than technical restrictions

## Installation

1. Install the module via Composer:
   ```bash
   composer require drupal/entity_browser_acquia_dam
   ```

2. Enable the module:
   ```bash
   drush en entity_browser_acquia_dam
   ```

3. Configure Acquia DAM credentials in your settings.

## Configuration

### Upload Widget Configuration

The upload widget requires minimal configuration:

```yaml
# Example configuration
media_type: 'image'  # Default media type (optional)
```

**Note**: The actual media type is determined by Acquia DAM based on file properties, so this setting is primarily for organizational purposes.

### Browser Widget Configuration

Configure the browser widget for optimal user experience:

```yaml
# Example configuration
media_type: 'image'
strict_format_restriction: true
items_per_page: 20
```

#### Configuration Options:

- **`media_type`**: The primary media type for this widget (e.g., 'image', 'video', 'document')
- **`strict_format_restriction`**: When enabled, the format filter shows only the relevant option and is disabled
- **`items_per_page`**: Number of assets to display per page

## Usage

### Setting Up Entity Browsers

1. Create or edit an Entity Browser
2. Add the "Acquia DAM Upload" widget for file uploads
3. Add the "Acquia DAM" widget for browsing existing assets
4. Configure the widgets according to your needs

### Content Creation Workflow

1. **Upload Assets**: Use the upload widget to add new files to DAM
2. **Browse Assets**: Use the browser widget to select existing DAM assets
3. **Automatic Integration**: Selected assets are automatically imported as Drupal media entities

## Technical Architecture

### Widget Classes

- **`AcquiaDamUpload`**: Handles file uploads to Acquia DAM
- **`AcquiaDam`**: Provides browsing and selection interface for DAM assets

### Key Features

- **Type Safety**: Proper array handling and validation
- **Error Handling**: Graceful handling of API failures and invalid assets
- **Authentication Management**: User-friendly authentication prompts when DAM access fails
- **Performance**: Efficient asset loading and caching
- **Accessibility**: WCAG-compliant interface with keyboard navigation

## Error Handling

### Authentication Failures
The module provides comprehensive error handling for authentication failures:

- **Form Loading**: When users are not authenticated, the widget displays a clear authentication message with a direct link to authenticate
- **Asset Browsing**: Authentication errors during asset loading show user-friendly messages instead of white screens
- **File Uploads**: Upload failures due to authentication issues provide clear guidance on how to authenticate
- **Asset Selection**: Authentication errors during asset fetching are handled gracefully with appropriate user feedback

### User Experience
- Detects authentication failures automatically
- Provides direct authentication links when possible
- Shows contextual error messages based on the operation being performed
- Maintains widget functionality even when some operations fail

## Styling

The module includes optimized CSS with:
- **CSS Custom Properties**: Consistent theming variables
- **Responsive Design**: Mobile-first approach
- **Accessibility**: High contrast and reduced motion support
- **Modern Standards**: Flexbox, CSS Grid, and progressive enhancement


## Support

For issues and feature requests, please refer to the module's issue queue or documentation.
