<?php

/**
 * @file
 * Hooks related to entity browser table and it's plugins.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter the fields on widget \Drupal\entity_browser_table\Plugin\Field\FieldWidget\EntityReferenceBrowserTableWidget.
 *
 * @param array $field_displays
 *   The array of field widget display plugins, keyed on the machine-readable
 *   name.
 * @param \Drupal\Core\Entity\ContentEntityInterface[] $entities
 *   Array of referenced entities.
 * @param string $details_id
 *   The ID for the details' element.
 */
function hook_entity_browser_table_alter(array &$field_displays, array $entities, string $details_id): void {
  $field_displays['#header']['type-preview'] = t('Type');
  foreach ($entities as $key => $entity) {
    $field_displays[$key][] = [
      'type-preview' => ['#markup' => $entity->bundle()],
    ];
  }
}

/**
 * @} End of "addtogroup hooks".
 */
