<?php

namespace Drupal\entity_bundle_scaffold\Plugin\EntityBundleClassMethodGenerator;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A getter method generator for taxonomy_enum fields.
 *
 * @EntityBundleClassMethodGenerator(
 *   id = "taxonomy_enum",
 *   provider = "taxonomy_enum",
 * )
 */
class TaxonomyEnumItem extends BaseEnumItem {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->entityTypeManager = $container->get('entity_type.manager');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  protected function getEnumClass(FieldDefinitionInterface $field): string {
    $handlerSettings = $field->getSetting('handler_settings');
    if (empty($handlerSettings['target_bundles'])) {
      throw new \RuntimeException('The taxonomy_enum field does not have a target bundle configured.');
    }

    $vid = reset($handlerSettings['target_bundles']);
    $vocabulary = $this->entityTypeManager->getStorage('taxonomy_vocabulary')->load($vid);
    $enumName = $vocabulary->getThirdPartySetting('taxonomy_enum', 'enum_name');

    return $enumName;
  }

}
