<?php

namespace Drupal\entity_bundle_scaffold\Plugin\EntityBundleClassMethodGenerator;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\entity_bundle_scaffold\EntityBundleClassMethodGeneratorBase;
use PhpParser\Builder\Method;
use PhpParser\Node\Identifier;
use PhpParser\Node\NullableType;

/**
 * A getter method generator for text fields.
 *
 * @EntityBundleClassMethodGenerator(
 *   id = "text",
 *   provider = "core",
 * )
 */
class Text extends EntityBundleClassMethodGeneratorBase {

  /**
   * {@inheritdoc}
   */
  public function buildGetter(FieldDefinitionInterface $field, Method $method, array &$uses): void {
    if ($this->helper->isFieldMultiple($field)) {
      $expression = sprintf('return array_map(
                  fn ($item): string => $item->processed,
                  iterator_to_array($this->get(\'%s\'))
              );', $field->getName());
    }
    else {
      $expression = sprintf('return $this->get(\'%s\')->processed;', $field->getName());
    }

    if ($this->helper->isFieldMultiple($field)) {
      $method->setReturnType('array');
      $method->setDocComment('/** @return string[] */');
    }
    elseif ($field->isRequired()) {
      $method->setReturnType('string');
    }
    else {
      $method->setReturnType(new NullableType(new Identifier('string')));
    }

    $method->addStmts($this->helper->parseExpression($expression));
  }

}
