<?php

namespace Drupal\entity_bundle_scaffold\Service\Helper;

/**
 * Helper methods for naming identifiers in generated code.
 */
class IdentifierNaming {

  /**
   * Check whether a certain word is a reserved keyword in PHP.
   */
  public static function isReservedKeyword(string $input): bool {
    return in_array(strtolower($input), [
      '__halt_compiler', 'abstract', 'and', 'array', 'as', 'break', 'callable', 'case', 'catch', 'class',
      'clone', 'const', 'continue', 'declare', 'default', 'die', 'do', 'echo', 'else', 'elseif', 'empty',
      'enddeclare', 'endfor', 'endforeach', 'endif', 'endswitch', 'endwhile', 'eval', 'exit', 'extends',
      'final', 'for', 'foreach', 'function', 'global', 'goto', 'if', 'implements', 'include', 'include_once',
      'instanceof', 'insteadof', 'interface', 'isset', 'list', 'match', 'namespace', 'new', 'or', 'print',
      'private', 'protected', 'public', 'readonly', 'require', 'require_once', 'return', 'static', 'switch',
      'throw', 'trait', 'try', 'unset', 'use', 'var', 'while', 'xor',
    ], TRUE);
  }

  /**
   * Strip characters that can't be used in identifiers in PHP.
   */
  public static function stripInvalidCharacters(string $string): string {
    if ($string === '') {
      return $string;
    }

    // A valid function name starts with a letter or underscore.
    while (!preg_match('/^[a-zA-Z_]/', $string) && $string !== '') {
      $string = substr($string, 1);
    }

    /*
     * Strip invalid characters
     * @see https://www.php.net/manual/en/functions.user-defined.php
     */
    return preg_replace('/[^a-zA-Z0-9_\x7f-\xff]*/i', '', $string);
  }

}
