<?php

namespace Drupal\entity_change\Plugin\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\Plugin\Context\ContextDefinition;
use Drupal\Core\Plugin\Context\EntityContextDefinition;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Component\Plugin\Context\ContextDefinitionInterface;

/**
 * Defines an EntityChange object.
 *
 * Plugin Namespace: Plugin\EntityChange
 *
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EntityChange extends Plugin {

  /**
   * Constructs an EntityChange plugin.
   *
   * @param string $id
   *    The plugin ID.
   * @param TranslatableMarkup $label
   *      The label of the action.
   * @param string $module
   *      The name of the module providing the EntityChange plugin.
   * @param ContextDefinitionInterface[] $context_definitions
   *      The types of entity this plugin applies to (empty means all).
   * @param string $type
   *      Optionally, identify the entity and/or bundle to which this applies.
   * @param class-string|null $deriver
   *   (optional) The deriver class, if any.
   *
   * Context Definitions are defined as:
   *
   * context_definitions: [
   *   'user' => new ContextDefinition(data_type: 'email', required: FALSE),
   * ]
   *
   * OR:
   *
   * context_definitions: [
   *   'user' => new EntityContextDefinition(
   *     data_type: 'entity:user',
   *     label: new TranslatableMarkup("User Context"),
   *     required: FALSE,
   *     constraints: [
   *       "NotNull" => [],
   *     ]
   *   ),
   * ]
   *
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly string $module,
    public readonly array $context_definitions = [],
    public readonly string $type = '',
    public readonly string|null $deriver = NULL,
  ) {}

}
