# Entity Clone Simple Sitemap

This module extends the Entity Clone module to also clone Simple Sitemap settings when entities are cloned.

## Requirements

- Drupal 10.x or 11.x
- Entity Clone module
- Simple Sitemap module

## Installation

1. Download and enable the module
2. The module will automatically start cloning sitemap settings when entities are cloned

## Features

- Automatically clones sitemap inclusion settings
- Supports all entity types that have sitemap configuration
- Logs cloning activities for debugging
- Handles errors gracefully

## How it works

The module implements an event subscriber for EntityCloneEvents::POST_CLONE:
-	It retrieves all Simple Sitemap overrides from the simple_sitemap_entity_overrides table for the original entity.
-	It inserts the same overrides for the cloned entity, ensuring that sitemap inclusion/exclusion rules are preserved.
-	For config entities (like content types or vocabularies), it can optionally reference global settings via the simple_sitemap.settings service.

No hooks or manual configuration are required.

## Configuration

No additional configuration is required. The module works automatically once enabled.
