<?php

namespace Drupal\entity_clone_simple_sitemap\EventSubscriber;

use Drupal\entity_clone\Event\EntityCloneEvent;
use Drupal\entity_clone\Event\EntityCloneEvents;
use Drupal\simple_sitemap\Manager\SitemapGetterInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber to clone Simple Sitemap settings.
 */
class SimpleSitemapCloneSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a SimpleSitemapCloneSubscriber obejct.
   *
   * @param \Drupal\simple_sitemap\Manager\SitemapGetterInterface $entityManager
   *   The simple_sitemap entity manager.
   */
  public function __construct(
    protected readonly SitemapGetterInterface $entityManager,
  ) {}

  /**
   * Handles the entity clone event to copy Simple Sitemap settings.
   *
   * @param \Drupal\entity_clone\Event\EntityCloneEvent $event
   *   The entity clone event.
   */
  public function onEntityClone(EntityCloneEvent $event): void {
    $original = $event->getEntity();
    $cloned = $event->getClonedEntity();

    $entity_type = $original->getEntityTypeId();
    $original_id = $original->id();
    $cloned_id = $cloned->id();

    foreach ($this->entityManager->setSitemaps()->getSitemaps() as $variant => $sitemap) {
      $settings = $this->entityManager
        ->setSitemaps($variant)
        ->getEntityInstanceSettings($entity_type, $original_id);

      if (!empty($settings[$variant])) {
        $this->entityManager
          ->setSitemaps($variant)
          ->setEntityInstanceSettings($entity_type, $cloned_id, $settings[$variant]);
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      EntityCloneEvents::POST_CLONE => 'onEntityClone',
    ];
  }

}
