<?php

namespace Drupal\entity_contact;

use Drupal\Core\Entity\Sql\SqlContentEntityStorage;

/**
 * Implementation of the entity_contact_message storage.
 */
class EntityContactMessageStorage extends SqlContentEntityStorage implements EntityContactMessageStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function deleteExpiredEntities(): void {
    foreach ($this->entityTypeManager->getStorage('entity_contact_form')
      ->loadMultiple() as $entity_contact_form) {
      /**
       * @var \Drupal\entity_contact\EntityContactFormInterface $entity_contact_form
       */

      $remove_stored_submissions_after = $entity_contact_form->getRemoveStoredSubmissionsAfter();

      if (empty($remove_stored_submissions_after)) {
        continue;
      }

      $created_before = strtotime($remove_stored_submissions_after);

      if (!$created_before) {
        continue;
      }

      $query = $this->getQuery();
      $query->accessCheck(FALSE);
      $query->condition('entity_contact_form', $entity_contact_form->id());
      $query->condition('created', $created_before, '<');
      $ids = $query->execute();

      $entities = $this->loadMultiple($ids);
      $this->delete($entities);
      $this->resetCache($ids);
    }
  }

}
