<?php

use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_counter\Plugin\EntityCounterSourceWithEntityConditionsInterface;
use Drupal\commerce_order\Entity\Order;
/**
 * @file
 * Hooks and documentation related to entity counter module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Control entity operation access for a specific entity type.
 *
 * @param bool $value
 *   The default transaction value.
 * @param \Drupal\Core\Entity\EntityInterface $entity
 *   The entity.
 * @param \Drupal\entity_counter\Plugin\EntityCounterSourceWithEntityConditionsInterface $source
 *   The entity counter source.
 *
 * @see \Drupal\entity_counter\Plugin\QueueWorker\EntityCounterEvaluateEntityQueueWorker::processItem
 */
function hook_ENTITY_COUNTER_SOURCE_PLUGIN_ID_alter(&$value, EntityInterface $entity, EntityCounterSourceWithEntityConditionsInterface $source) {
  if ($entity instanceof Order) {
    $value = $entity->getTotalPrice() ? $entity->getTotalPrice()->getNumber() : 0;
  }
}

/**
 * @} End of "addtogroup hooks".
 */
