# Entity Extra Field

## Introduction

The Entity Extra Field module allows site administrators to add various extra
fields to an entity display. These extra fields can consist of blocks, views,
or token values. Both entity form and view displays are supported.

Adding extra fields is common when building robust web applications that need
to be highly configurable. Use cases include adding missing elements such as
page titles, or rendering a block between two pieces of content.

- For a full description of the module, visit the
  [project page](https://www.drupal.org/project/entity_extra_field).

- To submit bug reports and feature suggestions or track changes, visit the
  [issue queue](https://www.drupal.org/project/issues/entity_extra_field).


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

After installing the base module, enable the Entity Extra Field UI submodule
(`entity_extra_field_ui`) to add new extra fields to entities through the user
interface.

**Note:** The UI module can be safely disabled after the extra fields have been
attached to an entity, which is useful in production environments where
field_ui should be disabled.


## Configuration

1. Navigate to the content types listing page at
   `/admin/structure/types`.

2. Click on the dropdown within the operations column for the desired content
   type.

3. Select the "Manage extra fields" option (e.g.,
   `/admin/structure/types/manage/page/extra-fields`).

4. You will see a list of all extra fields created for the given entity.

5. Click the "Add extra field" action link in the top left.

6. On the extra field add screen, select the field type you want to add:
    - **Block** - Render a block as a field
    - **View** - Render a view as a field
    - **Token** - Render token values as a field

7. Configure the extra field settings and click Save.

8. Depending on whether you selected "Form" or "View" for the display type,
   the extra field will appear at either:
    - Form display: `/admin/structure/types/manage/[type]/form-display`
    - View display: `/admin/structure/types/manage/[type]/display`

9. Adjust the render position on the entity display page and save your
   configuration.


## Maintainers

- Travis Tomka - [droath](https://www.drupal.org/u/droath)
