# Local Development

This project ships with a [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib) configuration so you can be productive quickly. Follow the steps below to spin up the containers, import the reference database, and start building.

## Prerequisites
- Docker Desktop (or another Docker runtime) running locally
- [DDEV](https://ddev.readthedocs.io/) v1.23 or newer installed on your machine
- `mkcert` installed if you want locally trusted HTTPS certificates (optional)

## First-Time Setup
1. Clone the repository and change into the project root.
2. Start the DDEV environment (initial start downloads the required containers):
   ```bash
   ddev start
   ```
3. Ensure PHP dependencies are present inside the container:
   ```bash
   ddev composer install
   ```
4. Import the provided database snapshot after the containers are running:
   ```bash
   ddev import-db --src local/db.local.sql.gz
   ```
   The archive is stored in `local/db.local.sql.gz`. DDEV handles the extraction automatically.
5. Clear Drupal caches and run any pending database updates:
   ```bash
   ddev drush cr
   ddev drush updb
   ```
6. Generate a one-time login link to access the site:
   ```bash
   ddev drush uli
   ```

Once complete, the site is available at https://entity-extra-field.ddev.site. Use `ddev launch` to open it in your default browser.

## Daily Workflow
- **Start containers:** `ddev start`
- **SSH into web container:** `ddev ssh`
- **Run Drush commands:** prefix with `ddev`, e.g. `ddev drush status`
- **Run automated tests:** `ddev phpunit` or `ddev test` (depending on the suite)
- **Stop containers:** `ddev stop`

## Database Refresh
If the reference database changes or you need to resync with teammate data:
1. Stop the project (`ddev stop`) to ensure clean state.
2. Replace `local/db.local.sql.gz` with the latest snapshot.
3. Start the project and run the import command again:
   ```bash
   ddev start
   ddev import-db --src local/db.local.sql.gz
   ```

## Troubleshooting
- Run `ddev describe` to confirm containers, ports, and URLs.
- If Docker or DDEV become unhealthy, run `ddev poweroff` and restart Docker Desktop.
- For a clean slate, remove the `.ddev/db_snapshots` directory and re-import the database.
- Visit https://entity-extra-field.ddev.site:8036 for phpMyAdmin if you need a database GUI.

For more advanced customization, consult the upstream DDEV Drupal Contrib documentation linked above.
