<?php

declare(strict_types=1);

namespace Drupal\entity_extra_field\ConfigTranslation;

use Drupal\config_translation\ConfigEntityMapper;

/**
 * Provides a configuration mapper for entity extra fields.
 */
class EntityExtraFieldMapper extends ConfigEntityMapper {

  /**
   * {@inheritdoc}
   */
  public function getBaseRouteName() {
    if ($this->entity) {
      $base_entity_type_id = $this->entity->getBaseEntityTypeId();
      return "entity.{$base_entity_type_id}.extra_fields.edit";
    }

    // During route building, the entity might not be set yet.
    // Fallback to our static fake "base_route_name" definition from the
    // translation yml:
    return $this->pluginDefinition['base_route_name'];
  }

  /**
   * {@inheritdoc}
   */
  public function getOverviewRoute() {
    // Routes are already created manually in RouteSubscriber.
    // Return the existing route from the collection if available:
    return $this->routeCollection->get($this->getOverviewRouteName());
  }

  /**
   * {@inheritdoc}
   */
  public function getAddRoute() {
    // Routes are already created manually in RouteSubscriber.
    // Return the existing route from the collection if available:
    return $this->routeCollection->get($this->getAddRouteName());
  }

  /**
   * {@inheritdoc}
   */
  public function getEditRoute() {
    // Routes are already created manually in RouteSubscriber.
    // Return the existing route from the collection if available:
    return $this->routeCollection->get($this->getEditRouteName());
  }

  /**
   * {@inheritdoc}
   */
  public function getDeleteRoute() {
    // Routes are already created manually in RouteSubscriber.
    // Return the existing route from the collection if available.
    return $this->routeCollection->get($this->getDeleteRouteName());
  }

  /**
   * {@inheritdoc}
   */
  public function getOverviewRouteName() {
    if ($this->entity) {
      $base_entity_type_id = $this->entity->getBaseEntityTypeId();
      return "entity.{$base_entity_type_id}.extra_fields.translate";
    }

    // Fallback to (potentially fake) base route name from the translation yml:
    return $this->getBaseRouteName();
  }

  /**
   * {@inheritdoc}
   */
  public function getAddRouteName() {
    if ($this->entity) {
      $base_entity_type_id = $this->entity->getBaseEntityTypeId();
      return "entity.{$base_entity_type_id}.extra_fields.translate.add";
    }

    // Fallback to (potentially fake) base route name from the translation yml:
    return $this->getBaseRouteName();
  }

  /**
   * {@inheritdoc}
   */
  public function getEditRouteName() {
    if ($this->entity) {
      $base_entity_type_id = $this->entity->getBaseEntityTypeId();
      return "entity.{$base_entity_type_id}.extra_fields.translate.edit";
    }

    // Fallback to (potentially fake) base route name from the translation yml:
    return $this->getBaseRouteName();
  }

  /**
   * {@inheritdoc}
   */
  public function getDeleteRouteName() {
    if ($this->entity) {
      $base_entity_type_id = $this->entity->getBaseEntityTypeId();
      return "entity.{$base_entity_type_id}.extra_fields.translate.delete";
    }

    // Fallback to (potentially fake) base route name from the translation yml:
    return $this->getBaseRouteName();
  }

  /**
   * {@inheritdoc}
   */
  public function getBaseRouteParameters() {
    // If the entity is not set, return an empty array:
    if (!$this->entity) {
      return [];
    }

    return parent::getBaseRouteParameters() + [
      $this->entity->getBaseEntityTypeBundleId() => $this->entity->getBaseBundleTypeId(),
    ];
  }

}
