/**
 * @file
 * JavaScript for identifier field group summary.
 */

(function ($) {
    'use strict';
    Drupal.behaviors.identifierFieldsetSummaries = {
      attach: function (context) {
        $(context).find('.identifier-form').drupalSetSummary(function (context) {
          // Find the identifier input field within the context.
          var identifierInput = context.querySelector('input[name*="[vk_identifier]"][name*="[value]"]') ||
                               context.querySelector('.js-form-item-vk-identifier-0-value input') ||
                               context.querySelector('input[name="vk_identifier[0][value]"]');
  
          var identifier = identifierInput ? identifierInput.value : '';
  
          if (identifier) {
            return Drupal.t('@identifier', {'@identifier': identifier});
          }
          else {
            return Drupal.t('Not set');
          }
        });
      }
    };
  })(jQuery);
  
  