<?php

namespace Drupal\entity_io\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Database\Connection;
use Drupal\Core\Datetime\DateFormatterInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controller for displaying entity IO logs.
 */
class EntityIoLogController extends ControllerBase {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * The date formatter service.
   *
   * @var \Drupal\Core\Datetime\DateFormatterInterface
   */
  protected $dateFormatter;

  /**
   * Constructor.
   */
  public function __construct(Connection $database, DateFormatterInterface $date_formatter) {
    $this->database = $database;
    $this->dateFormatter = $date_formatter;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('database'),
      $container->get('date.formatter')
    );
  }

  /**
   * Log page.
   */
  public function logPage() {
    $header = [
      'lid' => 'ID',
      'uid' => 'Usuário',
      'operation' => 'Operação',
      'entity_type' => 'Tipo',
      'entity_id' => 'ID Entidade',
      'status' => 'Status',
      'message' => 'Mensagem',
      'created' => 'Data',
    ];

    $query = $this->database->select('entity_io_log', 'l')
      ->fields('l')
      ->orderBy('created', 'DESC')
      ->range(0, 50);
    $rows = [];
    foreach ($query->execute() as $record) {
      $rows[] = [
        'lid' => $record->lid,
        'uid' => $record->uid,
        'operation' => $record->operation,
        'entity_type' => $record->entity_type,
        'entity_id' => $record->entity_id,
        'status' => $record->status,
        'message' => $record->message,
        'created' => $this->dateFormatter->format($record->created, 'short'),
      ];
    }

    return [
      '#type' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => $this->t('Nenhum log encontrado.'),
    ];
  }

}
