(function (Drupal, $, once) {
  Drupal.behaviors.toggleDiffsEntityTable = {
    attach: function (context, settings) {

      // Select all rows that match your pattern
      const rows = document.querySelectorAll('tr.nested-row + tr');

      rows.forEach(row => {
        // Find the table inside this row
        const diffsTable = row.querySelector('td .diffs-wrapper table.diffs-table');
        if (!diffsTable) return;

        // Initially hide the table
        // diffsTable.style.display = 'none';
        diffsTable.style.transition = 'all 0.3s ease';

        if (diffsTable) {
          diffsTable.parentElement.classList.add('entity-io-diff-table-collapsed')
        }

        // Add click event listener
        row.querySelector('td .diffs-wrapper > strong').addEventListener('click', function () {

          if (!diffsTable) return;
          // Toggle visibility
          // if (diffsTable.style.display === 'none') {
          //   diffsTable.style.display = 'table';
          // } else {
          //   diffsTable.style.display = 'none';
          // }
          diffsTable.parentElement.classList.toggle('entity-io-diff-table-collapsed');
        });
      });

    }
  };
})(Drupal, jQuery, once);
