<?php

namespace Drupal\entity_io_queue\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\user\Entity\User;

/**
 * Processes items for the Entity IO Queue.
 *
 * @QueueWorker(
 *   id = "entity_io_queue_import",
 *   title = @Translation("Entity IO Import Queue Worker"),
 *   cron = {"time" = 60}
 * )
 */
class EntityIoQueueImportWorker extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   */
  public function processItem($json_data) {

    $switcher = \Drupal::service('account_switcher');
    $run_as_user = User::load((int) 1);
    $switcher->switchTo($run_as_user);

    $entities = \Drupal::service('entity_io.entity_importer')->import(json_decode($json_data, TRUE));
    $log = \Drupal::service('entity_io.entity_importer')::$entityValidation;

    foreach ($log as $l) {
      \Drupal::logger('entity_io_queue')->error($l);
    }

    if ($entities && count($entities) === 1 && $entities[0] instanceof EntityInterface) {
      \Drupal::logger('entity_io_queue')->notice($this->t('Entity imported successfully.'));
    }
  }

  /**
   * Process the entire queue manually.
   */
  public function processQueue() {
    $queue = \Drupal::service('queue')->get('entity_io_queue_import');

    while ($item = $queue->claimItem()) {
      try {
        // Pass the item to the worker manually.
        $worker = \Drupal::service('plugin.manager.queue_worker')->createInstance('entity_io_queue_import');
        $worker->processItem($item->data);

        // Mark as successfully processed.
        $queue->deleteItem($item);
      }
      catch (\Exception $e) {
        \Drupal::logger('entity_io_queue')->error('Error processing item @id: @msg', [
          '@id' => $item->item_id,
          '@msg' => $e->getMessage(),
        ]);
        // Optionally release back to queue.
        $queue->releaseItem($item);
      }
    }
  }

}
