(function (Drupal, once, $) {
  Drupal.behaviors.entity_io = {
    attach(context) {
      once('entity-io-check-all', '.entity-io-check-all', context).forEach((el) => {
        el.addEventListener('click', (e) => {
          e.preventDefault();
          context.querySelectorAll('input[type="checkbox"]').forEach(cb => cb.checked = true);
        });
      });

      once('entity-io-clear-all', '.entity-io-clear-all', context).forEach((el) => {
        el.addEventListener('click', (e) => {
          e.preventDefault();
          context.querySelectorAll('input[type="checkbox"]').forEach(cb => cb.checked = false);
        });
      });

      once('entity-io-toggle', '.entity-io-toggle', context).forEach((el) => {
        el.addEventListener('click', (e) => {
          e.preventDefault();
          context.querySelectorAll('input[type="checkbox"]').forEach(cb => cb.checked = !cb.checked);
        });
      });

    }
  };
})(Drupal, once, jQuery);
