<?php

namespace Drupal\entity_io_webhooks\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Global settings for the Webhooks module.
 */
class WebhooksSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['entity_io_webhooks.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_io_webhooks_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('entity_io_webhooks.settings');

    $form['description'] = ['#markup' => $this->t('Configure default settings for webhooks. Per-bundle overrides are available on the entity pages.')];

    $form['default_headers'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Default headers (JSON or one per line "Key: Value")'),
      '#default_value' => $config->get('default_headers') ?? '',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $this->configFactory->getEditable('entity_io_webhooks.settings')
      ->set('default_events', array_values(array_filter($values['default_events'])))
      ->set('default_headers', $values['default_headers'])
      ->save();
    parent::submitForm($form, $form_state);
  }

}
