<?php

namespace Drupal\entity_io\Service;

use Drupal\Core\Database\Connection;
use Drupal\Core\Session\AccountProxyInterface;

/**
 * Service to log entity import/export operations.
 */
class EntityIoLogger {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;
  /**
   * The current user service.
   *
   * @var \Drupal\Core\Session\AccountProxyInterface
   */
  protected $currentUser;

  /**
   * Constructs an EntityIoLogger object.
   */
  public function __construct(Connection $database, AccountProxyInterface $current_user) {
    $this->database = $database;
    $this->currentUser = $current_user;
  }

  /**
   * Log an operation.
   */
  public function log($operation, $entity_type, $entity_id, $status, $message = '') {
    $this->database->insert('entity_io_log')
      ->fields([
        'uid' => $this->currentUser->id(),
        'operation' => $operation,
        'entity_type' => $entity_type ?? '',
        'entity_id' => $entity_id,
        'status' => $status,
        'message' => $message,
        'created' => \Drupal::time()->getRequestTime(),
      ])
      ->execute();
  }

}
