# Node JSON Drupal Module

## Overview

**Node JSON** is a comprehensive Drupal module designed to export and import entities (nodes, users, taxonomy terms, media, comments, blocks, etc.) in JSON format. It provides flexible configuration for selecting which fields to include, supports batch operations, and offers both UI and Drush command-line tools. The module is ideal for content migration, sharing, backup, and integration scenarios.

---

## Features

- **Export Entities to JSON:** Export nodes, users, taxonomy terms, media, comments, blocks, and more to structured JSON files.
- **Import Entities from JSON:** Import previously exported JSON files back into Drupal, supporting base and custom fields.
- **Field Selection:** Configure which base and custom fields to include in exports for each entity type.
- **Batch Export:** Export multiple entities at once, either by type or by specific IDs.
- **Revision Export:** Export specific revisions of nodes, media, blocks, and taxonomy terms.
- **Drush Integration:** Use Drush commands for automated or bulk export operations.
- **UI Forms:** User-friendly forms for selecting entities, configuring fields, and managing exports/imports.
- **Customizable Storage:** Configure where exported JSON files are stored.
- **Diff Viewer:** Visualize differences between entity revisions using a custom Twig template and CSS/JS libraries.
- **Extensible:** Includes a submodule (`entity_io_push`) for pushing JSON data to external endpoints.

---

## Folder Structure

```
entity_io/
├── css/                      # Styles for diff viewer
├── js/                       # JS for export UI and diff viewer
├── json/                     # Example exported JSON files
├── modules/
│   └── entity_io_push/       # Submodule for pushing JSON externally
├── src/
│   ├── Commands/             # Drush command classes
│   ├── Controller/           # Export controllers for revisions and API
│   ├── Form/                 # Forms for export/import/configuration
│   ├── Helper/               # Helper classes for entity and JSON operations
│   └── Service/              # Service classes for import/export/storage
├── templates/                # Twig templates for diff viewer
├── *.yml, *.install, *.module, *.txt, *.md
```

---

## Main Functionalities

### 1. Export Entities to JSON

- **UI Forms:** Export nodes, users, taxonomy terms, media, comments, blocks, etc. via dedicated forms (`src/Form/Export/*JsonExportForm.php`).
- **Batch Export:** Use `EntityBatchExportForm` and `EntityBatchIdsExportForm` for exporting multiple entities at once.
- **Revision Export:** Controllers like `NodeRevisionExportController`, `MediaRevisionExportController`, etc. allow exporting specific entity revisions.
- **Field Selection:** Configure which fields to export using forms in `src/Form/FormSettings/`.

### 2. Import Entities from JSON

- **UI Form:** `EntityJsonImportForm` allows importing entities from JSON files, mapping fields as configured.
- **Validation:** JSON is validated before import using helper classes (`JsonValidate`, `JsonParseEntityData`).

### 3. Field Configuration

- **Base & Custom Fields:** Select which fields to include in exports for each entity type (nodes, users, taxonomy terms, etc.).
- **Config Forms:** Located in `src/Form/FormSettings/`, these forms save field selections to config.

### 4. Drush Commands

- **Bulk Export:** Use Drush to export entities via `EntityExportCommands.php`.
- **Automation:** Integrate with scripts or CI/CD for automated exports.

### 5. Diff Viewer

- **Visual Comparison:** View differences between entity revisions using the `diffs-table.html.twig` template and supporting CSS/JS.
- **Integration:** Useful for content editors and site builders to track changes.

### 6. Storage Configuration

- **Custom Storage:** Configure where JSON files are saved via `EntityExportStorageSettingsForm`.
- **Service Layer:** `JsonStorageService` handles file operations.

### 7. Extensibility

- **Push Submodule:** `entity_io_push` allows sending exported JSON to external APIs or endpoints.
- **Service Classes:** Easily extend import/export logic via services in `src/Service/`.

---

## Key Classes & Files

- **Controllers:** Handle export endpoints and revision exports.
- **Forms:** UI for export/import, field selection, and storage settings.
- **Helpers:** Utility classes for entity loading, field extraction, JSON parsing/validation, and diffing.
- **Services:** Encapsulate import/export logic, storage, and field value extraction.
- **Drush Commands:** Command-line export functionality.
- **Templates:** Custom Twig for diff visualization.

---

## Usage

### Exporting Entities

1. Go to the export form for your entity type (e.g., Content → Export Nodes to JSON).
2. Select fields to include (configure via settings forms).
3. Choose entities to export (by type, by ID, or batch).
4. Download or view the exported JSON files.

### Importing Entities

1. Go to the import form.
2. Upload your JSON file.
3. Map fields if needed and submit.

### Configuring Fields

1. Go to the field settings form for your entity type.
2. Check/uncheck base and custom fields as desired.
3. Save configuration.

### Using Drush

```bash
drush entity-io:export node
drush entity-io:export user --fields=uid,name
```

### Viewing Diffs

- Access the diff viewer via the UI to compare entity revisions.

---

## Example JSON Files

See the `json/` folder for sample exports of various entity types.

---

## Requirements

- Drupal 9 or 10
- PHP 7.4+
- User module enabled for user exports/imports

---

## Extending

- Add new entity types by creating new export/import forms and controllers.
- Use the service classes for custom logic.
- Extend the push submodule for integration with external systems.

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
