(function (Drupal, $, once) {
  Drupal.behaviors.diffsSearchBehavior = {
    attach: function (context, settings) {

      // Para cada container .diffs-wrapper encontrado no contexto.
      $(once('diffs-search-wrapper', '.diffs-wrapper', context)).each(function () {
        const $wrapper = $(this);
        const $table = $wrapper.find('> table.diffs-table').first();

        if (!$table.length) {
          return;
        }

        // Cria dinamicamente o input se ele não existir dentro do wrapper.
        let $input = $wrapper.find('.diffs-search-input');
        if (!$input.length) {
          $input = $('<input>', {
            type: 'text',
            class: 'diffs-search-input',
            placeholder: Drupal.t('Search...'),
          }).prependTo($wrapper);
        }

        // Evento de busca.
        $input.on('input', function () {
          const termo = $(this).val().toLowerCase();
          const $linhas = $table.find('tbody tr');

          $linhas.each(function () {
            const $td = $(this).find('td').first();
            const texto = $td.text().toLowerCase();

            if (texto.includes(termo) || termo === '') {
              $(this).show();
            } else {
              $(this).hide();
            }
          });
        });
      });
    }
  };
})(Drupal, jQuery, once);
